<?php

namespace Recoded\Theme;

// TODO, move to Vite mu-plugin
final class Vite
{
    private string $distPath;
    private string|false $hotUrl;
    private object $manifest;

    private function css(string $entry): void
    {
        foreach ($this->manifest($entry)->css as $styleSheet) {
            $url = $this->distUrl($styleSheet);

            wp_register_style("vite-css/$styleSheet", $url);
            wp_enqueue_style("vite-css/$styleSheet", $url);
        }
    }

    private function distPath(?string $path = null): string
    {
        $this->distPath ??= get_template_directory() . '/public';

        return $path === null ? $this->distPath : $this->distPath . '/' . ltrim($path, '/');
    }

    private function distUrl(?string $path = null): string
    {
        $hotUrl = $this->hotUrl();
        $distUrl = $hotUrl === null
            ? get_template_directory_uri() . '/public/build'
            : $hotUrl;

        return $path === null ? $distUrl : $distUrl . '/' . ltrim($path, '/');
    }

    public function headHook(): void
    {
        if (!current_theme_supports('vite')) {
            return;
        }

        $hotUrl = $this->hotUrl();

        if ($hotUrl !== null) {
            wp_register_script('vite-client', $this->distUrl('@vite/client'), false, true);
            wp_enqueue_script('vite-client');

            wp_register_script('vite-js', $this->distUrl('resources/js/main.ts'), false, true);
            wp_enqueue_script('vite-js');

            return;
        }

        $this->js('resources/js/main.ts');
        $this->css('resources/js/main.ts');

        wp_register_script('vite-js', $this->distUrl($this->manifest('resources/js/main.ts')->file), false, true);
        wp_enqueue_script('vite-js');
    }

    private function hotUrl(): ?string
    {
        if (isset($this->hotUrl)) {
            return $this->hotUrl !== false
                ? $this->hotUrl
                : null;
        }

        $hotPath = $this->distPath('hot');

        if (!file_exists($hotPath)) {
            $this->hotUrl = false;

            return null;
        }

        return !empty($this->hotUrl = file_get_contents($hotPath))
            ? file_get_contents($hotPath)
            : null;
    }

    private function js(string $entry): void
    {
        foreach ($this->manifest($entry)->imports ?? [] as $import) {
            $url = get_template_directory_uri() . '/public/build/' . $this->manifest($import)->file;

            echo '<link rel="modulepreload" href="' . $url . '">';
        }
    }

    private function manifest(?string $entry = null): object
    {
        $this->manifest ??= json_decode(file_get_contents($this->distPath('build/manifest.json')));

        if ($entry === null) {
            return $this->manifest;
        }

        return $this->manifest->{$entry};
    }
}
