import { defineConfig, loadEnv } from 'vite';
import vue from '@vitejs/plugin-vue';
import laravel from 'laravel-vite-plugin';
import fs from 'fs';

// https://vitejs.dev/config/
export default ({ mode }) => {
    const wpHome = loadEnv(mode, '../', 'WP_HOME').WP_HOME;
    const host = new URL(wpHome).host;

    const server = host.endsWith('.test') ? {
        host,
        https: {
            key: fs.readFileSync(`/Users/noel/.config/valet/Certificates/${host}.key`),
            cert: fs.readFileSync(`/Users/noel/.config/valet/Certificates/${host}.crt`),
        },
    } : undefined;

    process.env.APP_URL = wpHome;

    return defineConfig({
        envDir: '../',
        plugins: [
            vue(),
            laravel.default({
                input: ['resources/js/main.ts'],
                refresh: true,
            }),
        ],
        server,
        experimental: {
            renderBuiltUrl: (filename) => `/app/themes/boilerplate-theme/public/build/${filename}`,
        },
    });
};
