# Recoded Coding Standard

Company-wide ruleset for [PHP_CodeSniffer](https://github.com/squizlabs/php_codesniffer).

```bash
composer require --dev recoded/coding-standard
```

## Configuration

Copy this example ruleset to your project root and save it as `phpcs.xml` or `phpcs.xml.dist`:

```xml
<?xml version="1.0" encoding="UTF-8"?>
<ruleset xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
         xsi:noNamespaceSchemaLocation="./vendor/squizlabs/php_codesniffer/phpcs.xsd">

    <rule ref="ReCodingStandard" />

    <rule ref="SlevomatCodingStandard.Files.TypeNameMatchesFileName">
        <properties>
            <property name="rootNamespaces" type="array">
                <element key="app" value="App" />
                <element key="database/factories" value="Database\Factories" />
                <element key="database/seeders" value="Database\Seeders" />
                <element key="tests" value="Tests" />
            </property>
        </properties>
    </rule>

    <file>app/</file>
    <file>config/</file>
    <file>database/</file>
    <file>lang/</file>
    <file>routes/</file>
    <file>tests/</file>

</ruleset>
```

## Running in GitHub Actions

Pull requests annotations require cs2pr to be installed ([cs2pr for setup-php](https://github.com/shivammathur/setup-php#tools-with-checkstyle-support)).

```yaml
- name: Run PHP_CodeSniffer
  run: vendor/bin/phpcs --report=checkstyle -q | cs2pr --graceful-warnings
```
