<?php

namespace _ReCodingStandard\Sniffs\Functions;

use PHP_CodeSniffer\Standards\Generic\Sniffs\PHP\ForbiddenFunctionsSniff;
use SlevomatCodingStandard\Helpers\SniffSettingsHelper;

final class ForbiddenOptionalSniff extends ForbiddenFunctionsSniff
{
    public $forbiddenFunctions = [];

    public function register(): array
    {
        $nullSafeAvailable = SniffSettingsHelper::isEnabledByPhpVersion(null, 80000);

        if ($nullSafeAvailable) {
            $this->forbiddenFunctions = ['optional' => null];
        }

        return parent::register();
    }
}
