<?php

namespace _ReCodingStandard\Support;

use PHP_CodeSniffer\Files\File;
use PHP_CodeSniffer\Util\Tokens;

/**
 * Inspired by {@see \SlevomatCodingStandard\Helpers\TokenHelper}, which is
 * marked as internal – and therefore not used.
 */
final class TokenFinder
{
    /**
     * Find the next token.
     *
     * @param (int|string)|(int|string)[] $types
     * @param \PHP_CodeSniffer\Files\File $file
     * @param int $startPointer Search starts at this token, inclusive
     * @param int|null $endPointer Search ends at this token, exclusive
     * @return int|null
     */
    public static function next($types, File $file, int $startPointer, ?int $endPointer = null): ?int
    {
        $token = $file->findNext($types, $startPointer, $endPointer);

        return $token === false ? null : $token;
    }

    /**
     * Find the next token except (one of) the given type(s).
     *
     * @see \SlevomatCodingStandard\Helpers\TokenHelper::findNextExcluding()
     * @param (int|string)|(int|string)[] $types
     * @param \PHP_CodeSniffer\Files\File $file
     * @param int $startPointer Search starts at this token, inclusive
     * @param int|null $endPointer Search ends at this token, exclusive
     * @return int|null
     */
    public static function nextExcept($types, File $file, int $startPointer, ?int $endPointer = null): ?int
    {
        $token = $file->findNext($types, $startPointer, $endPointer, true);

        return $token === false ? null : $token;
    }

    /**
     * Find the next token that is not empty (whitespace or comments).
     *
     * @see \SlevomatCodingStandard\Helpers\TokenHelper::findNextEffective()
     * @param \PHP_CodeSniffer\Files\File $file
     * @param int $startPointer Search starts at this token, inclusive
     * @param int|null $endPointer Search ends at this token, exclusive
     * @return int|null
     */
    public static function nextExceptEmpty(File $file, int $startPointer, ?int $endPointer = null): ?int
    {
        return self::nextExcept(Tokens::$emptyTokens, $file, $startPointer, $endPointer);
    }
}
