# laravel-testing-tools

## Form requests

Because all rules in a form request either pass or fail, you very quickly end up with a lot of possible scenarios for a
single form request. Testing all these scenarios through your controller may become very cumbersome very quickly. This
package allows you to test your form requests in isolation, allowing you to more quickly write tests for your
edge-cases.

```php
$this->createFormRequest(ResetPasswordRequest::class)
    ->as($user)
    ->route('token', 'password-reset-token')
    ->input([
        'current_password' => 'my-current-password',
        'new_password' => 'my-previous-password',
        'new_password_confirmation' => 'my-previous-password',
    ])
    ->assertPassesAuthorization()
    ->assertFailsValidation([
        'new_password' => 'The password you entered was used before, please choose something else.',
    ]);
```

## PHPUnit Assertions

This section details the available assertions for PHPUnit, note that you must include the `\Recoded\TestingTools\Concerns\ModelAssertions` trait in your test class to use the assertions.

### assertIsModel

Assert that 2 models are the same. The assertion will fail if the models point to different tables, primary keys and/or connections.

```php
$expected = User::find(1);
$actual = User::first();

$this->assertIsModel($expected, $actual);
```

### assertContainsModel

Assert that an enumerable contains a model.

```php
$needle = User::find(1);
$haystack = User::all();

$this->assertContainsModel($needle, $haystack);
```

## Mockery Matchers

This sections lists the added Mockery argument matchers, they allow you to more better define expectations within your tests.

### IsModel

This matcher matches Models that refer to the same record as the given model. This is especially handy when you're
expecting a call with a model, but the actual model instance is retrieved from the database by Laravel and outside your
control.

```php
use Recoded\TestingTools\Mockery\Matchers\IsModel;

$user = User::find(1);

Mockery::mock(UserPolicy::class)
    ->shouldReceive('viewAny')
    ->with(new IsModel($user))
    ->andReturnTrue();
```
