<?php

namespace Recoded\TestingTools\Concerns;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Foundation\Testing\Concerns\MakesHttpRequests;
use Illuminate\Http\Request;
use Illuminate\Routing\Route;
use Illuminate\Support\Facades\Auth;
use Recoded\TestingTools\Http\TestFormRequest;
use Symfony\Component\HttpFoundation\Request as SymfonyRequest;

trait InteractsWithFormRequests
{
    use MakesHttpRequests;

    /**
     * Create a new test form request instance.
     *
     * @template T of \Illuminate\Foundation\Http\FormRequest
     * @param class-string<T> $request
     * @param array<int|string, mixed> $parameters
     * @param array<string, string|string[]> $headers
     * @param string $method
     * @param string $url
     * @return \Recoded\TestingTools\Http\TestFormRequest<T>
     */
    protected function createFormRequest(
        string $request,
        array $parameters = [],
        array $headers = [],
        string $method = 'POST',
        string $url = '/test'
    ): TestFormRequest {
        $symfonyRequest = SymfonyRequest::create(
            $this->prepareUrlForRequest($url),
            $method,
            $parameters,
            $this->prepareCookiesForRequest(),
            [],
            array_replace($this->serverVariables, $this->transformHeadersToServerVars($headers)),
        );

        $route = new Route($method, $url, static fn () => null);
        $route->parameters = [];

        $formRequest = FormRequest::createFrom(Request::createFromBase($symfonyRequest), new $request());
        $formRequest->setContainer($this->app);
        $formRequest->setRouteResolver(static fn () => $route);
        $formRequest->setUserResolver(static fn () => Auth::user());

        return new TestFormRequest($formRequest);
    }
}
