<?php

namespace Recoded\TestingTools\Mockery\Matchers;

use Illuminate\Database\Eloquent\Model;
use Mockery\Matcher\MatcherAbstract;

class IsModel extends MatcherAbstract
{
    /**
     * The expected value.
     *
     * @var \Illuminate\Database\Eloquent\Model
     */
    protected $_expected;

    /**
     * Create a new Matcher.
     *
     * @param \Illuminate\Database\Eloquent\Model $expected
     * @return void
     */
    public function __construct(Model $expected)
    {
        parent::__construct($expected);
    }

    /**
     * Determine if the expected model matches the actual value.
     *
     * @param mixed $actual
     * @return bool
     */
    public function match(&$actual): bool
    {
        if (!$actual instanceof Model) {
            return false;
        }

        return $this->_expected->is($actual);
    }

    /**
     * Return a string representation of this Matcher.
     *
     * @return string
     */
    public function __toString(): string
    {
        $class = get_class($this->_expected);
        $key = $this->_expected->getKey();

        if (!is_scalar($key)) {
            $key = '<Object>';
        }

        return "<IsModel[{$class}:{$key}]>";
    }
}
