<?php

namespace Recoded\TestingTools\PHPUnit\Constraints;

use Illuminate\Database\Eloquent\Model;
use PHPUnit\Framework\Constraint\Constraint;

/**
 * @internal
 */
class EnumerableContainsModel extends Constraint
{
    /**
     * The expected model.
     *
     * @var \Illuminate\Database\Eloquent\Model
     */
    protected Model $value;

    /**
     * Create a new constraint instance.
     *
     * @param \Illuminate\Database\Eloquent\Model $value
     * @return void
     */
    public function __construct(Model $value)
    {
        $this->value = $value;
    }

    /**
     * Get the description of the failure.
     *
     * @param mixed $other
     * @return string
     */
    protected function failureDescription(mixed $other): string
    {
        return 'the given enumerable ' . $this->toString();
    }

    /**
     * Check if the given enumerable contains the expected model.
     *
     * @param \Illuminate\Support\Enumerable<array-key, mixed> $other
     * @return bool
     */
    protected function matches($other): bool
    {
        return $other->contains(function (mixed $item) {
            return $item instanceof Model && $item->is($this->value);
        });
    }

    /**
     * Get a string representation of the constraint.
     *
     * @return string
     */
    public function toString(): string
    {
        return 'contains the expected model';
    }
}
