<?php

use Illuminate\Foundation\Application;
use Illuminate\Foundation\Configuration\Middleware;

return Application::configure(basePath: dirname(__DIR__))
    ->withProviders()
    ->withRouting(
        web: __DIR__ . '/../routes/web.php',
        commands: __DIR__ . '/../routes/console.php',
    )
    ->withMiddleware(static function (Middleware $middleware) {
        $middleware
            ->trustHosts(subdomains: false)
            ->throttleApi();
    })
    ->withExceptions()
    ->create();
